/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.logistics.trains.IBogeyBlock;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TrainIconType;
import com.simibubi.create.content.logistics.trains.entity.TravellingPoint;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public class TrainPacket
extends SimplePacketBase {
    UUID trainId;
    Train train;
    boolean add;

    public TrainPacket(Train train, boolean add) {
        this.train = train;
        this.add = add;
    }

    public TrainPacket(class_2540 buffer) {
        int i;
        this.add = buffer.readBoolean();
        this.trainId = buffer.method_10790();
        if (!this.add) {
            return;
        }
        UUID owner = buffer.method_10790();
        ArrayList<Carriage> carriages = new ArrayList<Carriage>();
        ArrayList<Integer> carriageSpacing = new ArrayList<Integer>();
        int size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            Couple<Object> bogies = Couple.create(null, null);
            for (boolean first : Iterate.trueAndFalse) {
                if (!first && !buffer.readBoolean()) continue;
                IBogeyBlock type = (IBogeyBlock)class_2378.field_11146.method_10223(buffer.method_10810());
                bogies.set(first, new CarriageBogey(type, new TravellingPoint(), new TravellingPoint()));
            }
            int spacing = buffer.method_10816();
            carriages.add(new Carriage((CarriageBogey)bogies.getFirst(), (CarriageBogey)bogies.getSecond(), spacing));
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            carriageSpacing.add(buffer.method_10816());
        }
        boolean doubleEnded = buffer.readBoolean();
        this.train = new Train(this.trainId, owner, null, carriages, carriageSpacing, doubleEnded);
        this.train.name = class_2561.class_2562.method_10877((String)buffer.method_19772());
        this.train.icon = TrainIconType.byId(buffer.method_10810());
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.writeBoolean(this.add);
        buffer.method_10797(this.train.id);
        if (!this.add) {
            return;
        }
        buffer.method_10797(this.train.owner);
        buffer.method_10804(this.train.carriages.size());
        for (Carriage carriage : this.train.carriages) {
            for (boolean first : Iterate.trueAndFalse) {
                if (!first) {
                    boolean onTwoBogeys = carriage.isOnTwoBogeys();
                    buffer.writeBoolean(onTwoBogeys);
                    if (!onTwoBogeys) continue;
                }
                CarriageBogey bogey = carriage.bogeys.get(first);
                buffer.method_10812(RegisteredObjects.getKeyOrThrow((class_2248)bogey.type));
            }
            buffer.method_10804(carriage.bogeySpacing);
        }
        buffer.method_10804(this.train.carriageSpacing.size());
        this.train.carriageSpacing.forEach(arg_0 -> ((class_2540)buffer).method_10804(arg_0));
        buffer.writeBoolean(this.train.doubleEnded);
        buffer.method_10814(class_2561.class_2562.method_10867((class_2561)this.train.name));
        buffer.method_10812(this.train.icon.id);
    }

    @Override
    public void handle(Supplier<SimplePacketBase.Context> context) {
        context.get().enqueueWork(() -> {
            Map<UUID, Train> trains = CreateClient.RAILWAYS.trains;
            if (this.add) {
                trains.put(this.train.id, this.train);
            } else {
                trains.remove(this.trainId);
            }
        });
        context.get().setPacketHandled(true);
    }
}

